% Function: This is the program that generates an excel csv output with the 
% mean MFI for all of the IP/Probe combinations 

% Inputs:
% MedAvgDataCell - a cell array, where each entry is another cell array that 
%    contains the matrices with the mean MFI values for a each 
%    condition in a given experiment
% ExpNum - a numerical value for the number of experiments performed
% ConditionNum - a numerical value for the number of conditions/comparisons
%    performed
% IPProbeNum - a numerical value with the number of IP/Probe combinations
%    measured
% ConditionId - a cell array where the entries are strings naming the
%    different conditions/combinations being performed
% IPProbeList - a cell array with the names of the IP/Probes listed as
%    strings
% Filename - a string naming the file of the output

% Outputs:
% MFIOutputList - an output listing the mean MFI data as it is formatted 
% in the excel csv file
function [MFIOutputList] = ExcelMFIOutput(MedAvgCell,ExpNum,...
    ConditionNum,IPProbeNum,ConditionId,IPProbeList,FileName)

StringFormat = strcat('%s,%s,%s,', repmat('%f,',1,ExpNum*ConditionNum),...
    '\n');
fid = fopen(FileName,'wt');
MFIOutputList = zeros(IPProbeNum,ExpNum*ConditionNum);
Counter = 1;

Header = cell(1,ExpNum*ConditionNum+3);
Header{1,1} = 'IP';
Header{1,2} = 'Probe';
Header{1,3} = 'IP_Probe';

for alpha = 1:ConditionNum
   
     for i = 1:ExpNum
       
        ExpStr =  strcat('_', num2str(i)); 
        Header{1,3+Counter} = strcat(ConditionId{alpha},ExpStr);
         
        MFIOutputList(:,Counter) = MedAvgCell{i}{alpha}(:);
        Counter = Counter + 1;
        
     end
end

fprintf(fid,strcat(repmat('%s,',1,ExpNum*ConditionNum+3),'\n'), Header{:});

IPList = cell(IPProbeNum,1);
ProbeList = cell(IPProbeNum,1);

for beta = 1:IPProbeNum
    IPProbe_beta = strsplit(IPProbeList{beta},'_');
    IPList(beta) = IPProbe_beta(1);
    ProbeList(beta) = IPProbe_beta(2);
end
    
OutputCell = cell(IPProbeNum,ExpNum*ConditionNum+3);
[OutputCell(:,1)] = IPList;
[OutputCell(:,2)] = ProbeList;
[OutputCell(:,3)] = IPProbeList;
[OutputCell(:,4:end)] = num2cell(MFIOutputList);

for gamma=1:IPProbeNum
            fprintf(fid,StringFormat, OutputCell{gamma,:});
end

fclose(fid);